<?php $__env->startPush('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-5 col-xl-4 my-5">
                


                <h1 class="display-4 text-center mb-3">
                    Reset Password
                </h1>




                <form method="POST" action="<?php echo e(route('password.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="token" value="<?php echo e($token); ?>">

                    <!-- Email Input -->
                    <div class="form-group">
                        <label for="email_address" class="form-label">
                            Email address
                        </label>
                        <input name="email" type="email" id="email_address" value="<?php echo e(old('email')); ?>"
                            class="form-control" placeholder="name@address.com" required="required" autofocus="autofocus" />
                    </div>

                    <!-- Password Input -->
                    <div class="form-group">
                        <label for="password" class="form-label">
                            Password
                        </label>
                        <div class="input-group input-group-merge">
                            <input name="password" type="password" id="password" class="form-control"
                                placeholder="Enter your password" autocomplete="new-password" required="required" />
                            <span class="input-group-text">
                                <i class="fe fe-eye"></i>
                            </span>
                        </div>
                    </div>

                    <!-- Password Confirmation Input -->
                    <div class="form-group">
                        <label for="password_confirmation" class="form-label">
                            Password confirmation
                        </label>
                        <div class="input-group input-group-merge">
                            <input name="password_confirmation" type="password" id="password_confirmation"
                                class="form-control" placeholder="Confirm your password" required="required" />
                            <span class="input-group-text">
                                <i class="fe fe-eye"></i>
                            </span>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-lg w-100 btn-primary mb-3">
                        Reset Password
                    </button>
                </form>


            </div>
        </div>
    </div>
    <script>
        const inputPasswords = document.querySelectorAll('input[type="password"]');
        const eyeIcons = document.querySelectorAll('.fe-eye');

        eyeIcons.forEach((eyeIcon, index) => {
            eyeIcon.addEventListener('click', function() {
                const input = inputPasswords[index];
                const type = input.getAttribute('type') === 'password' ? 'text' : 'password';

                input.setAttribute('type', type);

                this.classList.toggle('fe-eye');
                this.classList.toggle('fe-eye-off');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('auth.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/flashdas/mirrormarketpro.org/resources/views/auth/reset-password.blade.php ENDPATH**/ ?>